﻿using System;
using System.Collections.Generic;

#if UNITY_PS5 || UNITY_PS4
using Unity.PSN.PS5;
using Unity.PSN.PS5.Aysnc;

#if UNITY_PS5
using Unity.PSN.PS5.Entitlement;
using Unity.PSN.PS5.PremiumFeatures;
#endif

#endif

namespace PSNSample
{
#if UNITY_PS5
    public class SonyEntitlements : IScreen
    {
        MenuLayout m_MenuEntitlements;

        public SonyEntitlements()
        {
            Initialize();
        }

        public MenuLayout GetMenu()
        {
            return m_MenuEntitlements;
        }

        public void OnEnter()
        {
        }

        public void OnExit()
        {
        }

        public void Process(MenuStack stack)
        {
            MenuEntitlements(stack);
        }

        public void Initialize()
        {
            m_MenuEntitlements = new MenuLayout(this, 450, 20);
        }

        public void MenuEntitlements(MenuStack menuStack)
        {
            m_MenuEntitlements.Update();

            bool enabled = true;

            if (m_MenuEntitlements.AddItem("Get Additional Content", "Get additional content entitlements", enabled))
            {
                Entitlements.GetAdditionalContentEntitlementListRequest request = new Entitlements.GetAdditionalContentEntitlementListRequest()
                {
                    ServiceLabel = 0
                };

                var requestOp = new AsyncRequest<Entitlements.GetAdditionalContentEntitlementListRequest>(request).ContinueWith((antecedent) =>
                {
                    if (SonyNpMain.CheckAysncRequestOK(antecedent))
                    {
                        OutputAdditionalContentList(antecedent.Request.Entitlements);
                    }
                });

                OnScreenLog.Add("Getting additional content entitlements...");

                Entitlements.Schedule(requestOp);
            }

            if (m_MenuEntitlements.AddBackIndex("Back"))
            {
                menuStack.PopMenu();
            }
        }

        private void OutputAdditionalContentList(Entitlements.AdditionalContentEntitlementInfo[] entitlements)
        {
            OnScreenLog.Add("Aditional Content : ");

            if (entitlements == null)
            {
                OnScreenLog.Add("    No entitlements");
            }
            else
            {
                for (int i = 0; i < entitlements.Length; i++)
                {
                    OnScreenLog.Add("      EntitlementLabel : " + entitlements[i].EntitlementLabel);
                    OnScreenLog.Add("      PackageType : " + entitlements[i].PackageType);
                    OnScreenLog.Add("      DownloadStatus : " + entitlements[i].DownloadStatus);

                    OnScreenLog.AddNewLine();
                }
            }
        }
    }
#endif
}

