# About &lt;package name&gt;

Use the &lt;package name&gt; package to &lt;list of the main uses for the package&gt;. For example, you can use &lt;package name&gt; to create/generate/extend/capture &lt;mention major use case, or a good example of what the package can be used for&gt;.

The &lt;package name&gt; package also includes &lt;other relevant features or uses&gt;.

> **Note**: Here are some examples for reference only. Do not include these in the final documentation file.

> *Use the Unity Recorder package to capture and save in-game data. For example, use Unity Recorder to record an mp4 file during a game session. The Unity Recorder package also includes an interface for setting-up and triggering recording sessions.*

> *AR Foundation allows you to work with augmented reality platforms in a multi-platform way within Unity.*
>
> *AR Foundation is a set of `MonoBehaviour`s and APIs for dealing with devices that support the following concepts:*
>
>* *World tracking: track the device's position and orientation in physical space.*
>* *Plane detection: detect horizontal and vertical surfaces.*
>* *Point clouds, also known as feature points.*
>* ... *etc.*


## Preview package
This package is available as a preview, so it is not ready for production use. The features and documentation in this package might change before it is verified for release.

>**Note**: For packages in preview or development, include the **Preview package** section, but remember to remove it completely when the package is verified.


## Package contents

The following table describes the package folder structure:

|**Location**|**Description**|
|---|---|
|*MyFolderName*|Contains &lt;describe what the folder contains&gt;.|
|*MyFolderName/MyFileName*|Contains &lt;describe what the file represents or implements&gt;.|

<a name="Installation"></a>

## Installation

To install this package, follow the instructions in the [Package Manager documentation](https://docs.unity3d.com/Manual/upm-ui-install.html).

>**Note**: This section begins with a cross-reference to the official Unity Manual topic on how to install packages. If the package requires special installation instructions, include these steps below:

In addition, you need to install the following resources:

- **&lt;name of resource 1&gt;**: To install, open **Window** > **&lt;name of menu item&gt;**.

	The resource appears &lt;at this location&gt;.

-  ... etc.


## Requirements

This version of &lt;package name&gt; is compatible with the following versions of the Unity Editor:

* 2018.1 and later (recommended)

>**Note**: You may also include additional requirements or recommendations for 3rd party software or hardware. If you need to include references to non-Unity products, make sure you refer to these products correctly and that all references include the proper copyright (&copy;), trademark (&trade;) or registered trademark(&reg;):

To use this package, you must have the following 3rd party products:

* &lt;product name and version&gt;&trade;
*  ...etc.


## Known limitations

&lt;package name&gt; version &lt;package version&gt; includes the following known limitations:

* &lt;brief one-line description of limitation.&gt;
*  ... etc.

>**Note**: If there are no known limitations, or if the limitations are trivial, exclude this section.
>
>Here is an example for reference only. Do not include this in the final documentation file:

---

*The Unity Recorder version 1.0 has the following limitations:*

* *The Unity Recorder does not support sound.*
* *The Recorder window and Recorder properties are not available in standalone Players.*
* *MP4 encoding is only available on Windows.*

---

## Helpful links

If you are new to &lt;package-name&gt;, or have a question after reading the documentation, you can:

* Watch the [Tutorials](https://www.youtube.com/playlist?list=PLAYLIST-ID) here.
* Join our [support forum](https://forum.unity.com/forums/FORUM-ID/).
* Follow us on [Twitter](http://www.twitter.com/TWITTER-ID).



<a name="UsingPackageName"></a>

# Using &lt;package name&gt;

To use the &lt;tool-name&gt;, attach this component to your GameObject and open the &lt;component-name&gt; in the Inspector:

`![The XXX component](images/LOCATION-OF-SCREENGRAB)`

Use this component to access the YYY and ZZZ properties which control ...

> **Note**: For a package containing a library, you can use this type of a description:

The XXX and YYY libraries contain APIs which allow you to &lt;do-something&gt;. The &lt;class-name&gt; class extends the &lt;other-class-name&gt; class so you can ...

You can implement a &lt;something&gt; using the XXX:

```C#
using Unity.Editor;
using MyPackage;
namespace MyNamespace
{
	    public class MyClass
    {
       ...
    }
}
```



<a name="Workflows"></a>
# &lt;package name&gt; workflows

To edit objects and elements:

1. Decide which tools can help you achieve the end results. There might be multiple solutions that can all produce the effect you want.
2. Select the element(s) that you want to modify. Often, the editing tool impacts which elements you need to select and how you need to select them.
3. Depending on which tool you are using, set any options to help customize the outcome or change the default settings.
4. Perform the action. Depending on what you are doing, this may be a simple matter of clicking a button. In some cases, you may be carrying out some intricate procedures. For example, you can click to ...



<a name="Advanced"></a>
# Advanced topics

This section provides more information on the following topics:

* [First topic](#first): provides a list of ...
* [Second topic](#second): explains the origin of ...
* etc.



<a name="first"></a>

## First topic

This is a list of ...



<a name="second"></a>

## Second topic

The XXX extends the YYY by tracking the ...



<a name="Reference"></a>

# XXX window

You can access these properties on the XXX window:

| **Property:** | **Function:** |
|:--- |:--- |
| __MySlider__ | Set this value to ... |
| __MyCheckbox__ | Enable this property to ... |
| __MyDropdownMenu__ | Choose how you want to ... |
| &nbsp;&nbsp;&nbsp;&nbsp; Value 1 | Select this value if ... This is the default. |
| &nbsp;&nbsp;&nbsp;&nbsp; Value 2 | Select this value if ... |
| &nbsp;&nbsp;&nbsp;&nbsp; Value 3 | Select this value if ... |
| __MyReference__ | Set a reference to ... |



<a name="Tutorials"></a>
# Tutorials

This tutorial demonstrates how to XXX by &lt;doing something&gt;:

1. Do the first task.

2. Do the second task. The following image appears:

	![A cinematic in the Timeline Editor window.](images/example.png)

4. etc ...
