﻿
using System;
using System.IO;
using Unity.PSN.PS5.Aysnc;
using Unity.PSN.PS5.Dialogs;
using Unity.PSN.PS5.Internal;
using UnityEngine;

#if UNITY_PS5
namespace Unity.PSN.PS5.Commerce
{
    /// <summary>
    /// Display commerce dialog
    /// </summary>
    public class CommerceDialogSystem
    {
        internal enum NativeMethods : UInt32
        {
            OpenDialog = 0x0E00001u,
            UpdateDialog = 0x0E00002u,
            CloseDialog = 0x0E00003u,
        }

        internal static void Start()
        {
        }

        internal static void Stop()
        {
        }

        /// <summary>
        /// Open Join premium dialog
        /// </summary>
        public class OpenJoinPremiumDialogRequest : Request
        {
            /// <summary>
            /// User ID
            /// </summary>
            public Int32 UserId { get; set; }

            /// <summary>
            /// The Status of the dialog
            /// </summary>
            public DialogSystem.DialogStatus Status { get; internal set; } = DialogSystem.DialogStatus.None;

            /// <summary>
            /// Close the dialog when it is open or just before being opened. 
            /// Call this if the request has already been scheduled.
            /// </summary>
            public void CloseDialog()
            {
                forceCloseDialog = true;
            }

            internal bool forceCloseDialog = false;

            /// <summary>
            /// Reset the request so it can be used again. Don't call this when the request has been scheduled.
            /// </summary>
            public void Reset()
            {
                forceCloseDialog = false;
                Status = DialogSystem.DialogStatus.None;
            }

            protected internal override void Run()
            {
                Status = DialogSystem.DialogStatus.None;

                if (forceCloseDialog == true)
                {
                    Status = DialogSystem.DialogStatus.ForceClosed;
                    return;
                }

                MarshalMethods.MethodHandle nativeMethod = MarshalMethods.PrepareMethod((UInt32)NativeMethods.OpenDialog);

                nativeMethod.Writer.Write(UserId);

                nativeMethod.Call();

                Result = nativeMethod.callResult;

                if (Result.apiResult == APIResultTypes.Success)
                {
                    MarshalMethods.ReleaseHandle(nativeMethod);

                    Status = DialogSystem.DialogStatus.Running;

                    // The dialog was opened sucessfully.
                    // Now keep updating the dialog until it is closed or forcefully closed.
                    //MarshalMethods.ReleaseHandle(nativeMethod);
                   
                }
                else
                {
                    MarshalMethods.ReleaseHandle(nativeMethod);
                }
            }

            protected internal override bool HasUpdate()
            {
                return Status == DialogSystem.DialogStatus.Running;
            }

            protected internal override bool Update()
            {
                // Return true to finish update, false to continue
                DialogSystem.DialogStatus currentStatus = DialogSystem.DialogStatus.None;

                if (forceCloseDialog == true)
                {
                    Result = ForceCloseDialog();
                    Status = DialogSystem.DialogStatus.ForceClosed;
                    return true;
                }

                bool finished = UpdateOpenedDialog(out currentStatus);

                if (finished == true)
                {
                    Status = currentStatus;
                }

                return finished;
            }
        }

        static APIResult ForceCloseDialog()
        {
            MarshalMethods.MethodHandle nativeMethod = MarshalMethods.PrepareMethod((UInt32)NativeMethods.CloseDialog);

            nativeMethod.Call();

            APIResult result = nativeMethod.callResult;

            MarshalMethods.ReleaseHandle(nativeMethod);

            return result;
        }

        static bool UpdateOpenedDialog(out DialogSystem.DialogStatus status)
        {
            bool finished = false;
            status = DialogSystem.DialogStatus.None;

            MarshalMethods.MethodHandle nativeMethod = MarshalMethods.PrepareMethod((UInt32)NativeMethods.UpdateDialog);

            nativeMethod.Call();               

            if (nativeMethod.callResult.apiResult == APIResultTypes.Success)
            {
                int sceStatus = nativeMethod.Reader.ReadInt32();

                if (sceStatus == 2) status = DialogSystem.DialogStatus.Running;

                bool hasFinished = nativeMethod.Reader.ReadBoolean();

                if (hasFinished == true)
                {
                    int sceDialogResult = nativeMethod.Reader.ReadInt32();

                    if (sceDialogResult == 0) status = DialogSystem.DialogStatus.FinishedOK;
                    else if (sceDialogResult == 1) status = DialogSystem.DialogStatus.FinishedCancel;
                    else if (sceDialogResult == 2) status = DialogSystem.DialogStatus.FinishedPurchased;

                    finished = true;
                }
            }

            MarshalMethods.ReleaseHandle(nativeMethod);

            return finished;
        }
    }
}
#endif
