
#include "Entitlements.h"
#include "HandleMsg.h"

#include <np/np_entitlement_access.h>

#if !__ORBIS__
namespace psn
{
	void EntitlementsSystem::RegisterMethods()
	{
		MsgHandler::AddMethod(Methods::GetAdditionalContentEntitlementList, EntitlementsSystem::GetAdditionalContentEntitlementListImpl);
	}

	void EntitlementsSystem::Initialize()
	{
		SceNpEntitlementAccessInitParam initParam;
		SceNpEntitlementAccessBootParam bootParam;

		/* Clear with 0's */
		memset(&initParam, 0, sizeof(SceNpEntitlementAccessInitParam));
		memset(&bootParam, 0, sizeof(SceNpEntitlementAccessBootParam));

		/* Initialize the NpEntitlementAccess library */
		sceNpEntitlementAccessInitialize(&initParam, &bootParam);
	}

	void EntitlementsSystem::GetAdditionalContentEntitlementListImpl(UInt8* sourceData, int sourceSize, UInt8* resultsData, int resultsMaxSize, int* resultsSize, APIResult* result)
	{
		*resultsSize = 0;

		BinaryReader reader(sourceData, sourceSize);
		SceNpServiceLabel serviceLabel = reader.ReadUInt32();

		SceNpEntitlementAccessAddcontEntitlementInfo *list = NULL; // If NULL is specified, only the number can be obtained
		uint32_t listNum = 0;
		uint32_t hitNum;
		int ret = sceNpEntitlementAccessGetAddcontEntitlementInfoList(serviceLabel, list, listNum, &hitNum);
		if (ret < 0) 
		{
			SCE_ERROR_RESULT(result, ret);
			return;
		}

		/* Prepare the required buffers */
		if (hitNum > 0)
		{
			list = (SceNpEntitlementAccessAddcontEntitlementInfo *)malloc(sizeof(SceNpEntitlementAccessAddcontEntitlementInfo) * hitNum);
			listNum = hitNum;

			/* Get a list of additional content information for which the entitlement is valid */
			ret = sceNpEntitlementAccessGetAddcontEntitlementInfoList(serviceLabel, list, listNum, &hitNum);
			if (ret < 0)
			{
				free(list);
				SCE_ERROR_RESULT(result, ret);
				return;
			}
		}

		// Write results
		BinaryWriter writer(resultsData, resultsMaxSize);

		writer.WriteInt32(hitNum);

		for (int i = 0; i < hitNum; i++)
		{
			writer.WriteString(list[i].entitlementLabel.data);
			writer.WriteUInt32(list[i].packageType);
			writer.WriteUInt32(list[i].downloadStatus);
		}

		*resultsSize = writer.GetWrittenLength();

		if ( list != NULL) free(list);

		SUCCESS_RESULT(result);
	}

}
#endif