# PS4 Cross-Gen

## Features

Not all PSN features available on PS5 can be used on the PS4. The follow table shows which Cross-gen features are supported. 

| Feature               | PS4 |  Notes
| -------------         |:---:|--------
| Authenticaton         | Yes |
| Entitlements          |     |
| Feature Gating        |     |
| Game Intent           | Yes | PS4 only support JoinSession invite type, see below for details
| Online Safety         | Yes | Profanity filter and test
| Player Sessions       | Yes |
| Sessions Manager      | Yes | 
| Trophy System         |     |
| Universal Data System |     |
| User System           | Yes | Presence, Friends, Profiles
| WebApi Notifications  | Yes | 

## SDK Instalation

This requires downloading the PS4 Cross-gen zip from the Prospero SDK manager. The zip needs copying into the PS4 SDK folder, typically reference **SCE_ORBIS_SDK_DIR** environment var.

For details on how to install cross-gen for the PS4 see SIE documention: https://p.siedev.net/resources/documents/SDK/1.000/Cross_Generation-Overview/0004.html

## Module

A new module needs adding to the modules list in the PS4 publishing settings. Add **libSceNpCppWebApi.prx** to the modules list.

## Param.json

The PS4 requires a limited param.json file to support. 

```json
{
  "gameIntent": {
    "permittedIntents": [
      {
        "intentType": "joinSession"
      }
    ]
  }
}
```

## Cross-gen Invites

Invites are recieved by the PS4 via GameIntent which requires the above **param.json** file to be in the **sys_sys** folder.

For invites to work between PS5 and PS4 the Session Manager Communication Ids need to match. The Session Manager service is shown on the PS5 **"Services"** tab for the product and on the PS4 **"Cross-gen"** tab. The IDs for these serivces must match for sessions and invites to work. 

## Sample

The sample will run on the PS4 with a reduced set of features, see the table above. 

When setting up the sample using the menu the "SCE Publishing Utils -> Set Publish Settings for PS4". 

