﻿using System;
using System.Collections.Generic;

#if UNITY_PS5 || UNITY_PS4
using Unity.PSN.PS5;
using Unity.PSN.PS5.Aysnc;

#if UNITY_PS5
using Unity.PSN.PS5.Commerce;
using Unity.PSN.PS5.Dialogs;
using UnityEngine;
#endif

#endif

namespace PSNSample
{
#if UNITY_PS5
    public class SonyCommerce : IScreen
    {
        MenuLayout m_MenuCommerce;

        public SonyCommerce()
        {
            Initialize();
        }

        public MenuLayout GetMenu()
        {
            return m_MenuCommerce;
        }

        public void OnEnter()
        {
        }

        public void OnExit()
        {
        }

        public void Update()
        {
            if (forceCloseRequest != null)
            {
                closeTimer -= Time.deltaTime;
                if (closeTimer < 0.0f)
                {
                    forceCloseRequest.CloseDialog();
                    OnScreenLog.AddWarning("Dialog Set to Force Close...");
                    forceCloseRequest = null;
                }
            }
        }

        public void Process(MenuStack stack)
        {
            MenuEntitlements(stack);
        }

        public void Initialize()
        {
            m_MenuCommerce = new MenuLayout(this, 450, 20);
        }

        CommerceDialogSystem.OpenJoinPremiumDialogRequest forceCloseRequest = null;
        float closeTimer = 0.0f;

        public void MenuEntitlements(MenuStack menuStack)
        {
            m_MenuCommerce.Update();

            bool userEnabled = false;

            if (GamePad.activeGamePad != null) //&& GamePad.activeGamePad.loggedInUser.onlineStatus == PlatformInput.OnlineStatus.SignedIn)
            {
                userEnabled = true;
            }

            if (m_MenuCommerce.AddItem("Open Join Premium Dialog", "Open the join premium dialog for the current user", userEnabled))
            {
                CommerceDialogSystem.OpenJoinPremiumDialogRequest request = new CommerceDialogSystem.OpenJoinPremiumDialogRequest()
                {
                    UserId = GamePad.activeGamePad.loggedInUser.userId,
                };

                var requestOp = new AsyncRequest<CommerceDialogSystem.OpenJoinPremiumDialogRequest>(request).ContinueWith((antecedent) =>
                {
                    if (SonyNpMain.CheckAysncRequestOK(antecedent))
                    {
                        OnScreenLog.Add("Dialog Status : " + antecedent.Request.Status);

                        OnScreenLog.Add("Dialog Closed...");
                    }
                });

                OnScreenLog.Add("Opening Dialog ...");

                DialogSystem.Schedule(requestOp);
            }

            if (m_MenuCommerce.AddItem("Open Join Dialog and Close", "Open the join premium dialog for the current user and force close the dialog after 5 seconds", userEnabled && forceCloseRequest == null))
            {
                CommerceDialogSystem.OpenJoinPremiumDialogRequest request = new CommerceDialogSystem.OpenJoinPremiumDialogRequest()
                {
                    UserId = GamePad.activeGamePad.loggedInUser.userId,
                };

                var requestOp = new AsyncRequest<CommerceDialogSystem.OpenJoinPremiumDialogRequest>(request).ContinueWith((antecedent) =>
                {
                    if (SonyNpMain.CheckAysncRequestOK(antecedent))
                    {
                        OnScreenLog.Add("Dialog Status : " + antecedent.Request.Status);

                        OnScreenLog.Add("Dialog Closed...");
                    }
                });

                OnScreenLog.Add("Opening Dialog ...");

                DialogSystem.Schedule(requestOp);

                forceCloseRequest = request;
                closeTimer = 5.0f;

            }

            if (m_MenuCommerce.AddBackIndex("Back"))
            {
                menuStack.PopMenu();
            }
        }
    }
#endif
}