﻿
#include "Commerce.h"
#include "HandleMsg.h"
#include "WebApi.h"
#include "WebApiNotifications.h"

#include <vector>
#include <np_commerce_dialog.h>

#if !__ORBIS__
namespace psn
{
	void CommerceCommands::RegisterMethods()
	{
		MsgHandler::AddMethod(Methods::OpenDialog, CommerceCommands::OpenDialogImpl);
		MsgHandler::AddMethod(Methods::UpdateDialog, CommerceCommands::UpdateDialogImpl);
		MsgHandler::AddMethod(Methods::CloseDialog, CommerceCommands::CloseDialogImpl);
	}

	void CommerceCommands::InitializeLib()
	{

	}

	void CommerceCommands::TerminateLib()
	{

	}

	bool CommerceCommands::s_DialogInitialized = false;

	void CommerceCommands::OpenDialogImpl(UInt8* sourceData, int sourceSize, UInt8* resultsData, int resultsMaxSize, int* resultsSize, APIResult* result)
	{
		int ret = 0;

		*resultsSize = 0;

		ret = InitialzeDialog();

		if (ret < 0)
		{
			SCE_ERROR_RESULT(result, ret);
			return;
		}

		BinaryReader reader(sourceData, sourceSize);

		Int32 userId = reader.ReadInt32();

		SceNpCommerceDialogParam param;
		sceNpCommerceDialogParamInitialize(&param);

		param.userId = userId;
		param.mode = SCE_NP_COMMERCE_DIALOG_MODE_PREMIUM;
		param.targets = NULL;
		param.numTargets = 0;
		param.features = SCE_NP_PREMIUM_FEATURE_REALTIME_MULTIPLAY; 

		ret = sceNpCommerceDialogOpen(&param);

		if (ret < 0)
		{
			SCE_ERROR_RESULT(result, ret);
			TerminateDialog();
			return;
		}

		BinaryWriter writer(resultsData, resultsMaxSize);

		*resultsSize = writer.GetWrittenLength();

		SUCCESS_RESULT(result);
	}

	void CommerceCommands::UpdateDialogImpl(UInt8* sourceData, int sourceSize, UInt8* resultsData, int resultsMaxSize, int* resultsSize, APIResult* result)
	{
		int ret = 0;

		*resultsSize = 0;

		SceCommonDialogStatus status = sceNpCommerceDialogUpdateStatus();
		SceNpCommerceDialogResult dialogResult;
		bool hasFinished = false;

		if (status == SCE_COMMON_DIALOG_STATUS_FINISHED)
		{
			ret = sceNpCommerceDialogGetResult(&dialogResult);

			if (ret < 0)
			{
				SCE_ERROR_RESULT(result, ret);
				TerminateDialog();
				return;
			}

			hasFinished = true;
			TerminateDialog();
		}
		
		BinaryWriter writer(resultsData, resultsMaxSize);

		writer.WriteInt32(status);
		writer.WriteBool(hasFinished);
		if (hasFinished == true)
		{
			writer.WriteInt32(dialogResult.result);
		}

		*resultsSize = writer.GetWrittenLength();

		SUCCESS_RESULT(result);
	}

	void CommerceCommands::CloseDialogImpl(UInt8* sourceData, int sourceSize, UInt8* resultsData, int resultsMaxSize, int* resultsSize, APIResult* result)
	{
		int ret = 0;

		*resultsSize = 0;

		ret = TerminateDialog();

		if (ret < 0)
		{
			SCE_ERROR_RESULT(result, ret);
			return;
		}

		BinaryWriter writer(resultsData, resultsMaxSize);

		*resultsSize = writer.GetWrittenLength();

		SUCCESS_RESULT(result);
	}

	int CommerceCommands::InitialzeDialog()
	{
		if (s_DialogInitialized == true) return 0;

		int ret = Utils::InitializeCommonDialog();

		if (ret < 0)
		{
			return ret;
		}

		ret = sceNpCommerceDialogInitialize();

		if (ret < 0)
		{
			return ret;
		}

		s_DialogInitialized = true;

		return ret;
	}

	int CommerceCommands::TerminateDialog()
	{
		if (s_DialogInitialized == false) return 0;

		int ret = sceNpCommerceDialogTerminate();

		if (ret < 0)
		{
			return ret;
		}

		s_DialogInitialized = false;

		return ret;
	}

}
#endif
