﻿using System;
using Unity.GameCore.Interop;

namespace Unity.GameCore
{
    public delegate void XblTitleManagedStatsWriteCompleted(Int32 hresult);

    public partial class SDK
    {
        public partial class XBL
        {
            public static void XblTitleManagedStatsWriteAsync(
                XblContextHandle xblContextHandle,
                UInt64 xboxUserId,
                XblTitleManagedStatistic[] statistics,
                XblTitleManagedStatsWriteCompleted completionRoutine)
            {
                if (xblContextHandle == null)
                {
                    completionRoutine(HR.E_INVALIDARG);
                    return;
                }

                XAsyncBlockPtr asyncBlock = AsyncHelpers.WrapAsyncBlock(defaultQueue.handle, (XAsyncBlockPtr block) =>
                {
                    Int32 hresult = XGRInterop.XAsyncGetStatus(block, wait: false);
                    completionRoutine(hresult);
                });

                using (var disposableCollection = new DisposableCollection())
                {
                    var interopStatistics = Array.ConvertAll(statistics, s => new Interop.XblTitleManagedStatistic(s, disposableCollection));
                    Int32 hr = XblInterop.XblTitleManagedStatsWriteAsync(
                        xblContextHandle.InteropHandle,
                        xboxUserId,
                        interopStatistics,
                        new SizeT(interopStatistics.Length),
                        asyncBlock);

                    if (HR.FAILED(hr))
                    {
                        AsyncHelpers.CleanupAsyncBlock(asyncBlock);
                        completionRoutine(hr);
                    }
                }
            }
        }
    }
}